clear all
set more off
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"

use wf_step1011.dta, clear

*** Population weights
egen sum_age_total = sum(age_total) if smpl2==1, by(year country)
gen pop_wgt =  age_total/sum_age_total

*==============================================================
*				Table 001
*==============================================================

reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_14 share_age_15_24 share_age_55_64 share_age_65plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density  ///
			[aw=pop_wgt]  if smpl2==1 , robust beta 
			
predict hyst_resid if e(sample), resid

sum ue2_hyst   if e(sample), d
gen hyst_resid2 = hyst_resid + r(p50)


reg  ue2_hyst ///
			turnmig_rate ///
			share_age_0_14 share_age_15_24 share_age_55_64 share_age_65plus ///	
			WVS_index_1 WVS_index_2 WVS_index_3 ///
			year_school ///		
			share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
			hh_size home_own_rate ///		
			netmig_rate urban_share_500_y1990 ///
			logY_ppp  mlog_road_density  ///
			cid_* [aw=pop_wgt]  if smpl2==1 , robust beta 
			
predict hyst_resid_fe if e(sample), resid
sum ue2_hyst   if e(sample), d
gen hyst_resid_fe2 = hyst_resid_fe + r(p50)

keep if smpl2==1 


*========================================================================

keep country nuts ue2_hyst  ///
			share_age_0_14 share_age_15_24 share_age_55_64 share_age_65plus share_age_0_24 share_age_55plus ///
			share_emp_primary_sector share_emp_secondary_sector share_emp_tertiary_sector ///
			ic_EMP_share_female ///
			year_school ///
			hh_size home_own_rate ///		
			turnmig_rate netmig_rate ///
			logY_ppp  log_road_density	///
			hyst_resid* ///
			urban_share_*  ///
			WVS_index* 
	
	
	
compress	
save wf_step4001, replace
